﻿unit Cloud_Columns;

interface

uses
  {$IF DEFINED (ISFEXGUI)}
  GUI,
  {$IFEND}
  Columns, DataStorage, SysUtils;

function GetTable(const Name : string) : TSQL_Table_array;

implementation

function GetTable(const Name : string) : TSQL_Table_array;
const

  Array_Items_CLD_BOX_SYNC_ITEMS: TSQL_Table_array = (
   (sql_col: 'DNT_NAME';             fex_col: 'Box Filename';      read_as: ftString;        convert_as: '';           col_type: ftString;       show: True),
   (sql_col: 'DNT_BOX_ID';           fex_col: 'Box ID';            read_as: ftString;        convert_as: '';           col_type: ftString;       show: True),
   (sql_col: 'DNT_CHECKSUM';         fex_col: 'Checksum';          read_as: ftString;        convert_as: '';           col_type: ftString;       show: True),
   (sql_col: 'DNT_SIZE';             fex_col: 'File Size';         read_as: ftInteger;       convert_as: '';           col_type: ftInteger;      show: True),
   (sql_col: 'DNT_ITEM_TYPE';        fex_col: 'Item Type';         read_as: ftString;        convert_as: '';           col_type: ftString;       show: True),
   (sql_col: 'DNT_OWNER_ID';         fex_col: 'Owner ID';          read_as: ftString;        convert_as: '';           col_type: ftString;       show: True),
   (sql_col: 'DNT_SQLLOCATION';      fex_col: 'Location';          read_as: ftString;        convert_as: '';           col_type: ftString;       show: True),
   );

  Array_Items_CLD_BOX_SYNC_LOCAL_ITEMS: TSQL_Table_array = (
   (sql_col: 'DNT_NAME';             fex_col: 'Box Filename';      read_as: ftString;        convert_as: '';           col_type: ftString;       show: True),
   (sql_col: 'DNT_SIZE';             fex_col: 'File Size';         read_as: ftInteger;       convert_as: '';           col_type: ftInteger;      show: True),
   (sql_col: 'DNT_SQLLOCATION';      fex_col: 'Location';          read_as: ftString;        convert_as: '';           col_type: ftString;       show: True),
   );

  Array_Items_CLD_BOX_SYNC_PREFERENCES: TSQL_Table_array = (
   (sql_col: 'DNT_ROWID';            fex_col: 'Row ID';            read_as: ftString;        convert_as: '';           col_type: ftString;       show: True),
   (sql_col: 'DNT_NAME';             fex_col: 'Field Name';        read_as: ftString;        convert_as: '';           col_type: ftString;       show: True),
   (sql_col: 'DNT_VALUE';            fex_col: 'Value';             read_as: ftString;        convert_as: '';           col_type: ftString;       show: True),
   (sql_col: 'DNT_SQLLOCATION';      fex_col: 'Location';          read_as: ftString;        convert_as: '';           col_type: ftString;       show: True),
  );

  Array_Items_CLD_GOOGLE_DRIVE_CELLO: TSQL_Table_array = (
   (sql_col: 'DNT_CREATED_DATE';     fex_col: 'Date Created';      read_as: ftLargeInt;      convert_as: 'UNIX_MS';    col_type: ftDateTime;     show: True),
   (sql_col: 'DNT_MODIFIED_DATE';    fex_col: 'Date Modified';     read_as: ftLargeInt;      convert_as: 'UNIX_MS';    col_type: ftDateTime;     show: True),
   (sql_col: 'DNT_VIEWED_BY_ME_DATE';fex_col: 'Date Viewed';       read_as: ftLargeInt;      convert_as: 'UNIX_MS';    col_type: ftDateTime;     show: True),
   (sql_col: 'DNT_TITLE';            fex_col: 'Title';             read_as: ftString;        convert_as: '';           col_type: ftString;       show: True),
   (sql_col: 'DNT_MIME_TYPE';        fex_col: 'Mime Type';         read_as: ftString;        convert_as: '';           col_type: ftString;       show: True),
   (sql_col: 'DNT_IS_OWNER';         fex_col: 'Owner';             read_as: ftString;        convert_as: '';           col_type: ftString;       show: True),
   (sql_col: 'DNT_QUOTA_BYTES';      fex_col: 'Quota Bytes';       read_as: ftString;        convert_as: '';           col_type: ftString;       show: True),
   (sql_col: 'DNT_SQLLOCATION';      fex_col: 'Location';          read_as: ftString;        convert_as: '';           col_type: ftString;       show: True),
  );

  Array_Items_CLD_GOOGLE_DRIVE_ITEMS: TSQL_Table_array = (
   (sql_col: 'DNT_MODIFIED';         fex_col: 'Modified';          read_as: ftLargeInt;      convert_as: 'UNIX';       col_type: ftDateTime;     show: True),
   (sql_col: 'DNT_FILENAME';         fex_col: 'Filename';          read_as: ftString;        convert_as: '';           col_type: ftString;       show: True),
   (sql_col: 'DNT_SIZE';             fex_col: 'File Size';         read_as: ftInteger;       convert_as: '';           col_type: ftInteger;      show: True),
   (sql_col: 'DNT_CHECKSUM';         fex_col: 'Checksum';          read_as: ftString;        convert_as: '';           col_type: ftString;       show: True),
   (sql_col: 'DNT_DOC_ID';           fex_col: 'Doc ID';            read_as: ftString;        convert_as: '';           col_type: ftString;       show: True),
   (sql_col: 'DNT_DOC_TYPE';         fex_col: 'Doc Type';          read_as: ftString;        convert_as: '';           col_type: ftString;       show: True),
   (sql_col: 'DNT_SQLLOCATION';      fex_col: 'Location';          read_as: ftString;        convert_as: '';           col_type: ftString;       show: True),
  );

  Array_Items_CLD_ONE_DRIVE_ACCOUNTS: TSQL_Table_array = (
   (sql_col: 'DNT_FIRSTNAME';                  fex_col: 'First Name';                      read_as: ftString;        convert_as: '';           col_type: ftString;       show: True),
   (sql_col: 'DNT_LASTNAME';                   fex_col: 'Last Name';                       read_as: ftString;        convert_as: '';           col_type: ftString;       show: True),
   (sql_col: 'DNT_EMAIL';                      fex_col: 'Email';                           read_as: ftString;        convert_as: '';           col_type: ftString;       show: True),
   (sql_col: 'DNT_ACCOUNTID';                  fex_col: 'Account ID';                      read_as: ftString;        convert_as: '';           col_type: ftString;       show: True),
   (sql_col: 'DNT_ACCOUNTTYPE';                fex_col: 'Account Type';                    read_as: ftString;        convert_as: '';           col_type: ftString;       show: True),
   (sql_col: 'DNT_DOMAIN';                     fex_col: 'Domain';                          read_as: ftString;        convert_as: '';           col_type: ftString;       show: True),
   (sql_col: 'DNT_FILEOPERATION';              fex_col: 'File Operation';                  read_as: ftString;        convert_as: '';           col_type: ftString;       show: True),
   (sql_col: 'DNT_FILEOPERATIONMANAGERSTATE';  fex_col: 'File Operation Manager State';    read_as: ftString;        convert_as: '';           col_type: ftString;       show: True),
   (sql_col: 'DNT_ISGOLDEN';                   fex_col: 'IsGolden';                        read_as: ftString;        convert_as: '';           col_type: ftString;       show: True),
   (sql_col: 'DNT_ONEDRIVEACCOUNT';            fex_col: 'OneDrive Account';                read_as: ftString;        convert_as: '';           col_type: ftString;       show: True),
   (sql_col: 'DNT_SERVICEDISPLAYNAME';         fex_col: 'Service Display Name';            read_as: ftString;        convert_as: '';           col_type: ftString;       show: True),
   (sql_col: 'DNT_SERVICEUSERID';              fex_col: 'Service User ID';                 read_as: ftString;        convert_as: '';           col_type: ftString;       show: True),
   (sql_col: 'DNT_SQLLOCATION';                fex_col: 'Location';                        read_as: ftString;        convert_as: '';           col_type: ftString;       show: True),
   );

  Array_Items_CLD_GOOGLE_LOCAL_MEDIA: TSQL_Table_array = (
   (sql_col: 'DNT_CAPTURE_TIMESTAMP';          fex_col: 'Capture Timestamp';               read_as: ftLargeInt;      convert_as: 'UNIX_MS';    col_type: ftDateTime;     show: True),
   (sql_col: 'DNT_FILENAME';                   fex_col: 'Filename';                        read_as: ftString;        convert_as: '';           col_type: ftString;       show: True),
   (sql_col: 'DNT_FILEPATH';                   fex_col: 'File Path';                       read_as: ftString;        convert_as: '';           col_type: ftString;       show: True),
   (sql_col: 'DNT_FIRST_BACKUP_TIMESTAMP';     fex_col: 'Fist Backup Timestamp';           read_as: ftLargeInt;      convert_as: 'UNIX_MS';    col_type: ftDateTime;     show: True),
   (sql_col: 'DNT_FOLDER_NAME';                fex_col: 'Folder Name';                     read_as: ftString;        convert_as: '';           col_type: ftString;       show: True),
   (sql_col: 'DNT_HEIGHT';                     fex_col: 'Height';                          read_as: ftString;        convert_as: '';           col_type: ftString;       show: True),
   (sql_col: 'DNT_WIDTH';                      fex_col: 'Width';                           read_as: ftString;        convert_as: '';           col_type: ftString;       show: True),
   (sql_col: 'DNT_DURATION';                   fex_col: 'Duration';                        read_as: ftString;        convert_as: '';           col_type: ftString;       show: True),
   (sql_col: 'DNT_LATITUDE';                   fex_col: 'Latitude';                        read_as: ftString;        convert_as: '';           col_type: ftString;       show: True),
   (sql_col: 'DNT_LONGITUDE';                  fex_col: 'Longitude';                       read_as: ftString;        convert_as: '';           col_type: ftString;       show: True),
   (sql_col: 'DNT_MEDIA_STORE_ID';             fex_col: 'Meida Store ID';                  read_as: ftString;        convert_as: '';           col_type: ftString;       show: True),
   (sql_col: 'DNT_PURGE_TIMESTAMP';            fex_col: 'Purge Timestamp';                 read_as: ftLargeInt;      convert_as: '';           col_type: ftString;       show: True),
   (sql_col: 'DNT_SIZE_BYTES';                 fex_col: 'Size';                            read_as: ftString;        convert_as: '';           col_type: ftString;       show: True),
   (sql_col: 'DNT_TIMEZONE_OFFSET';            fex_col: 'Timezone Offset';                 read_as: ftString;        convert_as: '';           col_type: ftString;       show: True),
   (sql_col: 'DNT_SQLLOCATION';                fex_col: 'Location';                        read_as: ftString;        convert_as: '';           col_type: ftString;       show: True),
  );

    Array_Items_NULL: TSQL_Table_array = (
    (sql_col: '';
    fex_col: '';
    read_as: ftString;
    convert_as: '';
    col_type: ftString;
    show: false));    

begin
  if Name = 'CLD_BOX_SYNC_ITEMS' then Result := Array_Items_CLD_BOX_SYNC_ITEMS else
  if Name = 'CLD_BOX_SYNC_LOCAL_ITEMS' then Result := Array_Items_CLD_BOX_SYNC_LOCAL_ITEMS else
  if Name = 'CLD_GOOGLE_DRIVE_CELLO' then Result := Array_Items_CLD_GOOGLE_DRIVE_CELLO else
  if Name = 'CLD_GOOGLE_DRIVE_ITEMS' then Result := Array_Items_CLD_GOOGLE_DRIVE_ITEMS else
  if Name = 'CLD_GOOGLE_PHOTOS_LOCAL_MEDIA' then Result := Array_Items_CLD_GOOGLE_LOCAL_MEDIA else
  if Name = 'CLD_ONE_DRIVE_ITEMS' then Result := Array_Items_CLD_ONE_DRIVE_ACCOUNTS else
  if Name = 'CLD_BOX_SYNC_PREFERENCES' then Result := Array_Items_CLD_BOX_SYNC_PREFERENCES else
  begin
    Result := Array_Items_NULL;
    {$IF DEFINED (ISFEXGUI)}
    ShowMessage('Cloud' + ':' + #13#10 + #13#10 + 'Did not locate artifact column layout:' + #13#10 + #13#10 + Name);
    {$IFEND}
    Progress.Log(format('%-54s %-100s', ['Error: Did not locate artifact column layout:', Name]));
  end;
end;
end.
